# VITS:Conditional Variational Autoencoder with Adversarial Learning for End-to-End Text-to-Speech

## 论文

[VITS](https://arxiv.org/abs/2106.06103)

## 模型结构

在这项工作中，作者提出了一种并行端到端 TTS 方法，它生成的音频比目前的两阶段模型更自然。该方法采用了变异推理，并增加了归一化流和对抗训练过程，从而提高了生成模型的表现力。作者还提出了一种随机时长预测器，可根据输入文本合成具有不同节奏的语音。通过对潜在变量的不确定性建模和随机时长预测器，该的方法表达了自然的一对多关系，即一个文本输入可以用不同的音调和节奏以多种方式说话。在 LJ Speech（一个单一说话者数据集）上进行的人类主观评估（平均意见分或 MOS）表明，该方法优于最佳的公开 TTS 系统，其 MOS 可与标准答案相媲美。

![image-20240829142644186](image-20240829142644186.png)

## 环境配置

### Docker（方法一）

```
#拉取镜像
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
#创建容器
docker run --shm-size 80g --network=host --name=telechat --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined  -v /opt/hyhal:/opt/hyhal:ro -v <Host Path>:<Container Path> -it <Your Image ID> bash

#安装依赖
cd vits
pip install -r requirements.txt -i https://pypi.mirrors.ustc.edu.cn/simple/
apt-get install espeak
cd monotonic_align
python setup.py build_ext --inplace

```

### Anaconda（方法二）

1、关于本项目 DCU 显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
DTK驱动：dtk-24.04.1
python：python3.10
torch:2.1
torchvision:0.16.0
torchaudio:2.1.2
```

2、其它非特殊库参照 requirements.txt 安装

```
cd vits
pip install -r requirements.txt -i https://pypi.mirrors.ustc.edu.cn/simple/
apt-get install espeak
cd monotonic_align
python setup.py build_ext --inplace
```

## 训练步骤

### 数据集下载与处理

- 训练任务采用 LJ Speech-1.1 数据集，下载地址：https://data.keithito.com/data/speech/LJSpeech-1.1.tar.bz2

- 下载完成后，在 vits 文件夹下创建连接：

  ```
  ln -s /path/to/LJSpeech-1.1/wavs DUMMY1
  ```

### 代码修改

- STFT：

  ```
  vim /usr/local/lib/python3.10/site-packages/torch/functional.py
  ##把第650行的 normalized, onesided, return_complex)
  ##改为
  normalized, onesided, return_complex=True)
  ```

### 单卡训练

```
bash run_single.sh
```

### 多卡训练

```
bash run_multi.sh
```

*注意，每次运行训练后，DUMMY1 目录下会多出许多 .pt 文件，如果再次训练的话会报错，所以需要每次训练后把所有的 .pt 文件给删除：

```
rm -rf DUMMY1/*.pt
```

## 源码仓库及问题反馈



## 参考资料

https://github.com/jaywalnut310/vits/tree/main